﻿/*
 * Created by SharpDevelop.
 * User: SONA-03
 * Date: 06/07/2015
 * Time: 16:23
 * Celui qui lit ce fichier, je l'invite à boire une Guinness!
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Windows.Forms;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data;
using System.Linq;

using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;

using DetailNumber.CS;

namespace MACRO_SONA
{
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    [Autodesk.Revit.DB.Macros.AddInId("9FFE06D5-9D26-4552-88C8-404D47425886")]
	public partial class ThisDocument
	{
		#region Class Member Variables
        /// <summary>
        /// Active document to which this RoomsData instance belongs
        /// </summary>
        Document m_doc;

        /// <summary>
        /// a list to store all rooms in the project
        /// </summary>
        List<Room> m_rooms = new List<Room>();

        /// <summary>
        /// parameters which will be displayed in DataGridView
        /// </summary>
        List<BuiltInParameter> m_parameters = new List<BuiltInParameter>();

        /// <summary>
        /// a list to store column names of Rooms
        /// </summary>
        List<String> m_columnNames = new List<string>();
        #endregion        
                
		private void Module_Startup(object sender, EventArgs e)
		{

		}

		private void Module_Shutdown(object sender, EventArgs e)
		{

		}

		#region Revit Macros generated code
		private void InternalStartup()
		{
			this.Startup += new System.EventHandler(Module_Startup);
			this.Shutdown += new System.EventHandler(Module_Shutdown);
		}
		#endregion
	
		#region Class Public Methods
		
		
		
		#region Class Implementation                
        /// <summary>
        /// Initialize the parameters displayed in DataGridView control
        /// </summary>
        private void InitializeParameters()
        {
           
        }
        #endregion
        
		public void PurgeRooms()
		{
			m_doc = this.Document;	
			List<Room> m_unplacedRooms = new List<Room>();
			int nElements = 0;
			
			using(Transaction trans = new Transaction(m_doc, "Test"))
        	{
        		trans.Start();	
			
 				RoomFilter filter = new RoomFilter();
            	FilteredElementCollector collector = new FilteredElementCollector(m_doc);
            	m_rooms = collector.WherePasses(filter).ToElements().Cast<Room>().ToList<Room>();
            
				foreach(Room room in m_rooms )			     
				{
					if ((room.Area == 0) && (room.Perimeter == 0))
				    {
					    	m_unplacedRooms.Add(room);
				    }
			    }
				
				// display a message box
            switch (m_unplacedRooms.Count)
            {
                case 0:
                    MessageBox.Show("Aucune pièce non placée trouvée!", "Test Macro", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    break;                    
                default:
                    if (MessageBox.Show("Supprimer la ou les " + m_unplacedRooms.Count + " pièce(s) non placée(s) trouvée(s)?", "Test Macro", MessageBoxButtons.YesNo, MessageBoxIcon.Information) == System.Windows.Forms.DialogResult.Yes)
                    {
                        
                        foreach( Room room in m_unplacedRooms )
				        {
				          
				          nElements += m_doc.Delete(room.Id).Count;			 
				          
				        }
                                                
                        MessageBox.Show(m_unplacedRooms.Count + " pièce(s) non placée(s) supprimée(s).", "Test Macro", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                        
                    }                        
                  break;
            }
            
        		trans.Commit();
        	}
		}
	}
}